<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_navigations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('icon');
            $table->string('url');
            $table->string('type');
            $table->string('name');
            $table->integer('position')->default(0);
            $table->json('translation')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_navigations');
    }
};
